/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.message.server;

import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;

    public OkPacket(ReadableByteBuf buf, Context context) {
        buf.skip();
        this.affectedRows = buf.readLongLengthEncodedNotNull();
        this.lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (context.hasClientCapability(0x800000L) && buf.readableBytes() > 0) {
            buf.skip(buf.readIntLengthEncodedNotNull());
            block4: while (buf.readableBytes() > 0) {
                if (buf.readIntLengthEncodedNotNull() <= 0) continue;
                switch (buf.readByte()) {
                    case 0: {
                        buf.readIntLengthEncodedNotNull();
                        String variable = buf.readString(buf.readIntLengthEncodedNotNull());
                        Integer len = buf.readLength();
                        String value = len == null ? null : buf.readString(len);
                        logger.debug("System variable change:  {} = {}", variable, value);
                        continue block4;
                    }
                    case 1: {
                        buf.readIntLengthEncodedNotNull();
                        Integer dbLen = buf.readLength();
                        String database = dbLen == null ? null : buf.readString(dbLen);
                        context.setDatabase(database.isEmpty() ? null : database);
                        logger.debug("Database change: is '{}'", database);
                        continue block4;
                    }
                }
                buf.skip(buf.readIntLengthEncodedNotNull());
            }
        }
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }
}

